package org.eclipse.jem.tests.beaninfo.infos;
/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.beans.*;
import org.eclipse.jem.tests.beaninfo.*;
import org.eclipse.jem.tests.beaninfo.preq.infos.BaseBeanInfo;
public class Test2ClassBBeanInfo extends BaseBeanInfo {
	
/**
 * Gets the bean class.
 * @return java.lang.Class
 */
public Class getBeanClass() {
	return Test2ClassB.class;
}
    
public BeanDescriptor getBeanDescriptor() {
	java.beans.BeanDescriptor aDescriptor = null;
	try {
		/* Create and return the WindowBeanInfobean descriptor. */
		aDescriptor = new java.beans.BeanDescriptor(getBeanClass(), getBeanClass());	// Just for yucks, made customizer the same class.
		aDescriptor.setDisplayName("A name for this class.");
	} catch (Throwable exception) {
	};
	return aDescriptor;
}
/**
 * Return the event set descriptors for this bean.
 * @return java.beans.EventSetDescriptor[]
 */
public java.beans.EventSetDescriptor[] getEventSetDescriptors() {
	try {
		EventSetDescriptor aDescriptorList[] = {
			createEventSetDescriptor(getBeanClass(), 
				"overrideName", 
				new Object[0],
				new MethodDescriptor[] {
					super.createMethodDescriptor(org.eclipse.jem.tests.beaninfo.ITest1ClassEventListener.class, "event1", 
						new Object[] { DISPLAYNAME, "Event 1"},
						new ParameterDescriptor[0],
						new Class[] {java.util.EventObject.class}),					
				},
				org.eclipse.jem.tests.beaninfo.ITest1ClassEventListener.class,
				"addTest2ClassBEventListener",
				"removeTest2ClassBEventListener")
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
	/**
	 * @return an icon of the specified kind for JButton
	 */
	public java.awt.Image getIcon(int kind) {
   return super.getIcon(kind);
	}
/**
 * Return the method descriptors for this bean.
 * @return java.beans.MethodDescriptor[]
 */
public java.beans.MethodDescriptor[] getMethodDescriptors() {
	try {
		MethodDescriptor aDescriptorList[] = {		
			super.createMethodDescriptor(getBeanClass(),"isSetA", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "is SetA",//$NON-NLS-1$
			   	EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Create the window peer",
	    		}, 
	    		new ParameterDescriptor[] {},
	      	new Class[] {}		    		
		  	),
			super.createMethodDescriptor(getBeanClass(),"setSetA", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "set SetA",//$NON-NLS-1$
			   	EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Create the window peer",
	    		}, 
	    		new ParameterDescriptor[] {createParameterDescriptor("aBooleanSetting", new Object[0])},
	      	new Class[] {Boolean.TYPE}		    		
		  	)		  	

		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
/**
 * Return the property descriptors for this bean.
 * @return java.beans.PropertyDescriptor[]
 */
public java.beans.PropertyDescriptor[] getPropertyDescriptors() {
	try {
		PropertyDescriptor aDescriptorList[] = {
			// focusOwner
			super.createPropertyDescriptor(getBeanClass(),"setA", new Object[] {//$NON-NLS-1$
	    			}
		    	),
		    	new IndexedPropertyDescriptor("foo", getBeanClass())
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}	

}